#include "structs.h"

color* add_colors(color *c1, color *c2)
{
	c1->r += c2->r;
	c1->g += c2->g;
	c1->b += c2->b;
	return c1;
}

color* multiply_color(color *c1, double d)
{
	c1->r = c1->r*d;
	c1->g = c1->g*d;
	c1->b = c1->b*d;
	return c1;
}

color* clear_color(color *c1)
{
	c1->r = 0;
	c1->g = 0;
	c1->b = 0;
	return c1;
}

color* normalize_color(color *c)
{
	if (c->r < 0.0)
		c->r = 0.0;
	if (c->g < 0.0)
		c->g = 0.0;
	if (c->b < 0.0)
		c->b = 0.0;

	if (c->r > 255)
		c->r = 255;
	if (c->g > 255)
		c->g = 255;
	if (c->b > 255)
		c->b = 255;
		
	return c;
}

void color_from_number(color *c, int n)
{
	c->r = ((n+1)*240) % 255;
	c->g = ((n+1)*4800) % 255;
	c->b = ((n+1)*960) % 255;
}
